/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.diva.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public final class GeneralUtils {
    public static final int MACINTOSH = 0;
    public static final int WINDOWS_XP = 1;
    public static final int WINDOWS_98 = 2;
    public static final int WINDOWS_NT = 3;
    public static final int WINDOWS_2000 = 4;
    public static final int WINDOWS_2003 = 5;
    public static final int WINDOWS_XX = 6;
    public static final int UNIX = 99;

    private GeneralUtils() {
    }

    public static int getOS() {
        String osName = System.getProperty("os.name");
        if ((osName = osName.toLowerCase()).equalsIgnoreCase("windows xp")) {
            return 1;
        }
        if (osName.equalsIgnoreCase("windows 2000")) {
            return 4;
        }
        if (osName.equalsIgnoreCase("windows nt")) {
            return 3;
        }
        if (osName.equalsIgnoreCase("windows 98")) {
            return 2;
        }
        if (osName.equalsIgnoreCase("windows 2003")) {
            return 5;
        }
        if (osName.startsWith("windows")) {
            return 6;
        }
        if (osName.startsWith("mac os")) {
            return 0;
        }
        return 99;
    }

    public static boolean isExternalURL(String href) {
        if (href != null) {
            return (href = href.toLowerCase()).startsWith("http") || href.startsWith("www") || href.startsWith("ftp:");
        }
        return false;
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getShortDate(Date date) {
        if (date == null) {
            return "";
        }
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        return df.format(date);
    }

    public static Date getNow() {
        Calendar c = Calendar.getInstance();
        return c.getTime();
    }

    public static Class getClassFromJar(String className, File jarFile) {
        try {
            URL url = jarFile.toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url});
            return loader.loadClass(className);
        }
        catch (Exception ex) {
            System.out.println("Could not create class: " + className + " " + ex);
            return null;
        }
    }

    public static Object getClassInstanceFromJar(String className, File jarFile) {
        Object o = null;
        try {
            Class c = GeneralUtils.getClassFromJar(className, jarFile);
            if (c != null) {
                o = c.newInstance();
            }
        }
        catch (Exception ex) {
            System.out.println("Could not create class instance: " + className + " " + ex);
            return null;
        }
        return o;
    }
}

