/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.diva.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public final class HTMLUtils {
    public static String getTagText(File htmlFile, String tagName) throws IOException {
        String encoding = HTMLUtils.getCharset(htmlFile);
        TagFinderParserCallback callback = new TagFinderParserCallback(tagName);
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(htmlFile), encoding);
        new ParserDelegator().parse(reader, callback, true);
        return callback.text;
    }

    public static String getCharset(File htmlFile) throws IOException {
        CharsetFinderParserCallback charsetCallback = new CharsetFinderParserCallback();
        FileReader reader = new FileReader(htmlFile);
        new ParserDelegator().parse(reader, charsetCallback, true);
        String encoding = charsetCallback.text;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    public static class CharsetFinderParserCallback
    extends HTMLEditorKit.ParserCallback {
        boolean done;
        String text;

        CharsetFinderParserCallback() {
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
            String s;
            int index;
            Object o;
            if (attrSet != null && !this.done && (o = attrSet.getAttribute(HTML.Attribute.CONTENT)) != null && (index = (s = o.toString()).indexOf("charset")) != -1 && (index = s.indexOf("=", index)) != -1) {
                try {
                    this.text = s.substring(index + 1);
                }
                catch (IndexOutOfBoundsException ex) {
                    // empty catch block
                }
                this.done = true;
            }
        }
    }

    public static class TagFinderParserCallback
    extends HTMLEditorKit.ParserCallback {
        boolean tag_found;
        boolean done;
        String text;
        String _tagName;

        TagFinderParserCallback(String tagName) {
            this._tagName = tagName;
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
            if (!this.tag_found && tag.toString().equals(this._tagName)) {
                this.tag_found = true;
            }
        }

        public void handleText(char[] data, int pos) {
            if (this.tag_found && !this.done) {
                this.text = new String(data);
                this.done = true;
            }
        }
    }
}

