CPAPI.packageName = "Help System";
CPAPI._defaultOrg = 0;
CPAPI.showSearch = true;
CPAPI.orgArray(0).organizationName = "Contents";
CPAPI.orgArray(0).organizationIdentifier = "helpsystem";
CPAPI.orgArray(0).itemArray(0).itemTitle = "Introduction";
CPAPI.orgArray(0).itemArray(0).itemIdentifier = "introduction";
CPAPI.orgArray(0).itemArray(0).itemParent = "menu";
CPAPI.orgArray(0).itemArray(0).itemHyper = "";
CPAPI.orgArray(0).itemArray(0).keyWords = "";
CPAPI.orgArray(0).itemArray(0).comments = "";

CPAPI.orgArray(0).itemArray(1).itemTitle = "RELOAD Help";
CPAPI.orgArray(0).itemArray(1).itemIdentifier = "reloadhelp";
CPAPI.orgArray(0).itemArray(1).itemParent = "introduction";
CPAPI.orgArray(0).itemArray(1).itemHyper = "content/topic1/subtopic1.html";
CPAPI.orgArray(0).itemArray(1).keyWords = "contact,comments,version";
CPAPI.orgArray(0).itemArray(1).comments = "This page includes introductory comments for the help system.";

CPAPI.orgArray(0).itemArray(2).itemTitle = "What Does RELOAD Do?";
CPAPI.orgArray(0).itemArray(2).itemIdentifier = "whatdoesreloaddo";
CPAPI.orgArray(0).itemArray(2).itemParent = "introduction";
CPAPI.orgArray(0).itemArray(2).itemHyper = "content/topic1/subtopic2.html";
CPAPI.orgArray(0).itemArray(2).keyWords = "function,what";
CPAPI.orgArray(0).itemArray(2).comments = "This page describes the functions and capabilities of RELOAD Editor";

CPAPI.orgArray(0).itemArray(3).itemTitle = "RELOAD Philosophy";
CPAPI.orgArray(0).itemArray(3).itemIdentifier = "reloadphilosophy";
CPAPI.orgArray(0).itemArray(3).itemParent = "introduction";
CPAPI.orgArray(0).itemArray(3).itemHyper = "content/topic1/subtopic3.html";
CPAPI.orgArray(0).itemArray(3).keyWords = "pedagogy,interoperability,reuse,re-use,valkenburg";
CPAPI.orgArray(0).itemArray(3).comments = "This page gives some background about RELOAD - why it is needed and what it supports.";

CPAPI.orgArray(0).itemArray(4).itemTitle = "Getting Started";
CPAPI.orgArray(0).itemArray(4).itemIdentifier = "gettingstarted";
CPAPI.orgArray(0).itemArray(4).itemParent = "menu";
CPAPI.orgArray(0).itemArray(4).itemHyper = "";
CPAPI.orgArray(0).itemArray(4).keyWords = "";
CPAPI.orgArray(0).itemArray(4).comments = "";

CPAPI.orgArray(0).itemArray(5).itemTitle = "System Requirements";
CPAPI.orgArray(0).itemArray(5).itemIdentifier = "systemrequirements";
CPAPI.orgArray(0).itemArray(5).itemParent = "gettingstarted";
CPAPI.orgArray(0).itemArray(5).itemHyper = "content/topic2/subtopic1.html";
CPAPI.orgArray(0).itemArray(5).keyWords = "system requirements";
CPAPI.orgArray(0).itemArray(5).comments = "This page tells you what specification of computer you need to run RELOAD.";

CPAPI.orgArray(0).itemArray(6).itemTitle = "Installation";
CPAPI.orgArray(0).itemArray(6).itemIdentifier = "installation";
CPAPI.orgArray(0).itemArray(6).itemParent = "gettingstarted";
CPAPI.orgArray(0).itemArray(6).itemHyper = "content/topic2/subtopic2.html";
CPAPI.orgArray(0).itemArray(6).keyWords = "installation,installing,download, get RELOAD";
CPAPI.orgArray(0).itemArray(6).comments = "This page covers installation of the tool";

CPAPI.orgArray(0).itemArray(7).itemTitle = "Uninstalling";
CPAPI.orgArray(0).itemArray(7).itemIdentifier = "uninstalling";
CPAPI.orgArray(0).itemArray(7).itemParent = "gettingstarted";
CPAPI.orgArray(0).itemArray(7).itemHyper = "content/topic2/subtopic3.html";
CPAPI.orgArray(0).itemArray(7).keyWords = "This page describes the process of uninstalling the tool.";
CPAPI.orgArray(0).itemArray(7).comments = "uninstalling,uninstall,files,folders,directories";

CPAPI.orgArray(0).itemArray(8).itemTitle = "Conventions";
CPAPI.orgArray(0).itemArray(8).itemIdentifier = "conventions";
CPAPI.orgArray(0).itemArray(8).itemParent = "gettingstarted";
CPAPI.orgArray(0).itemArray(8).itemHyper = "content/topic2/subtopic4.html";
CPAPI.orgArray(0).itemArray(8).keyWords = "how";
CPAPI.orgArray(0).itemArray(8).comments = "This page provides background on how the help system is written.";

CPAPI.orgArray(0).itemArray(9).itemTitle = "The Reload Project";
CPAPI.orgArray(0).itemArray(9).itemIdentifier = "thereloadproject";
CPAPI.orgArray(0).itemArray(9).itemParent = "menu";
CPAPI.orgArray(0).itemArray(9).itemHyper = "";
CPAPI.orgArray(0).itemArray(9).keyWords = "";
CPAPI.orgArray(0).itemArray(9).comments = "";

CPAPI.orgArray(0).itemArray(10).itemTitle = "Funding";
CPAPI.orgArray(0).itemArray(10).itemIdentifier = "funding JISC,";
CPAPI.orgArray(0).itemArray(10).itemParent = "thereloadproject";
CPAPI.orgArray(0).itemArray(10).itemHyper = "content/topic3/subtopic1.html";
CPAPI.orgArray(0).itemArray(10).keyWords = "funding,";
CPAPI.orgArray(0).itemArray(10).comments = "This page describes the funding arrangements for Reload";

CPAPI.orgArray(0).itemArray(11).itemTitle = "RELOAD Team";
CPAPI.orgArray(0).itemArray(11).itemIdentifier = "reloadteam";
CPAPI.orgArray(0).itemArray(11).itemParent = "thereloadproject";
CPAPI.orgArray(0).itemArray(11).itemHyper = "content/topic3/subtopic2.html";
CPAPI.orgArray(0).itemArray(11).keyWords = "Reload Team","team members";
CPAPI.orgArray(0).itemArray(11).comments = "This page lists the team members and advisors.";

CPAPI.orgArray(0).itemArray(12).itemTitle = "Open Source";
CPAPI.orgArray(0).itemArray(12).itemIdentifier = "opensource";
CPAPI.orgArray(0).itemArray(12).itemParent = "thereloadproject";
CPAPI.orgArray(0).itemArray(12).itemHyper = "content/topic3/subtopic3.html";
CPAPI.orgArray(0).itemArray(12).keyWords = "mit license,open source,";
CPAPI.orgArray(0).itemArray(12).comments = "This page describes the licensing details of RELOAD.";

CPAPI.orgArray(0).itemArray(13).itemTitle = "Contribute";
CPAPI.orgArray(0).itemArray(13).itemIdentifier = "contribute";
CPAPI.orgArray(0).itemArray(13).itemParent = "thereloadproject";
CPAPI.orgArray(0).itemArray(13).itemHyper = "content/topic3/subtopic4.html";
CPAPI.orgArray(0).itemArray(13).keyWords = "help,contribute,report,";
CPAPI.orgArray(0).itemArray(13).comments = "This page describes how you can contribute to RELOAD.";

CPAPI.orgArray(0).itemArray(14).itemTitle = "Background";
CPAPI.orgArray(0).itemArray(14).itemIdentifier = "background";
CPAPI.orgArray(0).itemArray(14).itemParent = "menu";
CPAPI.orgArray(0).itemArray(14).itemHyper = "";
CPAPI.orgArray(0).itemArray(14).keyWords = "";
CPAPI.orgArray(0).itemArray(14).comments = "";

CPAPI.orgArray(0).itemArray(15).itemTitle = "IMS Specifications";
CPAPI.orgArray(0).itemArray(15).itemIdentifier = "imspecifications";
CPAPI.orgArray(0).itemArray(15).itemParent = "background";
CPAPI.orgArray(0).itemArray(15).itemHyper = "content/topic4/subtopic1.html";
CPAPI.orgArray(0).itemArray(15).keyWords = "content packaging,metadata,simple sequencing";
CPAPI.orgArray(0).itemArray(15).comments = "This page introduces the specifications.";

CPAPI.orgArray(0).itemArray(16).itemTitle = "3rd Party User Guides";
CPAPI.orgArray(0).itemArray(16).itemIdentifier = "thirdpartyuserguides";
CPAPI.orgArray(0).itemArray(16).itemParent = "background";
CPAPI.orgArray(0).itemArray(16).itemHyper = "content/topic4/subtopic2.html";
CPAPI.orgArray(0).itemArray(16).keyWords = "resources,content packaging,metadata,simple sequencing";
CPAPI.orgArray(0).itemArray(16).comments = "This page links to 3rd party resources which may be of use.";

CPAPI.orgArray(0).itemArray(17).itemTitle = "Content Packaging Resources";
CPAPI.orgArray(0).itemArray(17).itemIdentifier = "contentpackagingresources";
CPAPI.orgArray(0).itemArray(17).itemParent = "background";
CPAPI.orgArray(0).itemArray(17).itemHyper = "content/topic4/subtopic3.html";
CPAPI.orgArray(0).itemArray(17).keyWords = "content packaging,resources,what";
CPAPI.orgArray(0).itemArray(17).comments = "This page links to Content Packaging resources.";

CPAPI.orgArray(0).itemArray(18).itemTitle = "Metadata Resources";
CPAPI.orgArray(0).itemArray(18).itemIdentifier = "metadataresources";
CPAPI.orgArray(0).itemArray(18).itemParent = "background";
CPAPI.orgArray(0).itemArray(18).itemHyper = "content/topic4/subtopic4.html";
CPAPI.orgArray(0).itemArray(18).keyWords = "metadata,resources,what";
CPAPI.orgArray(0).itemArray(18).comments = "This page links to Metadata resources.";

CPAPI.orgArray(0).itemArray(19).itemTitle = "Simple Sequencing Resources";
CPAPI.orgArray(0).itemArray(19).itemIdentifier = "simplesequencingresources";
CPAPI.orgArray(0).itemArray(19).itemParent = "background";
CPAPI.orgArray(0).itemArray(19).itemHyper = "content/topic4/subtopic5.html";
CPAPI.orgArray(0).itemArray(19).keyWords = "simple sequencing,resources,what";
CPAPI.orgArray(0).itemArray(19).comments = "This page links to Simple Sequencing resources.";

CPAPI.orgArray(0).itemArray(20).itemTitle = "SCORM Resources";
CPAPI.orgArray(0).itemArray(20).itemIdentifier = "scormresources";
CPAPI.orgArray(0).itemArray(20).itemParent = "background";
CPAPI.orgArray(0).itemArray(20).itemHyper = "content/topic4/subtopic6.html";
CPAPI.orgArray(0).itemArray(20).keyWords = "SCORM, ADL, resources, what";
CPAPI.orgArray(0).itemArray(20).comments = "This page links to SCORM resources.";

CPAPI.orgArray(0).itemArray(21).itemTitle = "Tutorial";
CPAPI.orgArray(0).itemArray(21).itemIdentifier = "tutorial";
CPAPI.orgArray(0).itemArray(21).itemParent = "menu";
CPAPI.orgArray(0).itemArray(21).itemHyper = "";
CPAPI.orgArray(0).itemArray(21).keyWords = "";
CPAPI.orgArray(0).itemArray(21).comments = "";

CPAPI.orgArray(0).itemArray(22).itemTitle = "Workspace";
CPAPI.orgArray(0).itemArray(22).itemIdentifier = "workspace";
CPAPI.orgArray(0).itemArray(22).itemParent = "tutorial";
CPAPI.orgArray(0).itemArray(22).itemHyper = "content/topic5/subtopic1.html";
CPAPI.orgArray(0).itemArray(22).keyWords = "workspace,pane,menu,toolbar";
CPAPI.orgArray(0).itemArray(22).comments = "This page describes the RELOAD Editor workspace.";

CPAPI.orgArray(0).itemArray(23).itemTitle = "Exemplar Content";
CPAPI.orgArray(0).itemArray(23).itemIdentifier = "exemplarcontent";
CPAPI.orgArray(0).itemArray(23).itemParent = "tutorial";
CPAPI.orgArray(0).itemArray(23).itemHyper = "content/topic5/subtopic2.html";
CPAPI.orgArray(0).itemArray(23).keyWords = "test package exemplar content";
CPAPI.orgArray(0).itemArray(23).comments = "This page provides access to some exemplar content";

CPAPI.orgArray(0).itemArray(24).itemTitle = "Your First Content Package";
CPAPI.orgArray(0).itemArray(24).itemIdentifier = "yourfirstcontentpackage";
CPAPI.orgArray(0).itemArray(24).itemParent = "tutorial";
CPAPI.orgArray(0).itemArray(24).itemHyper = "content/topic5/subtopic3.html";
CPAPI.orgArray(0).itemArray(24).keyWords = "tutorial";
CPAPI.orgArray(0).itemArray(24).comments = "This page introduces the RELOAD tutorial.";

CPAPI.orgArray(0).itemArray(25).itemTitle = "Collect Resources Together";
CPAPI.orgArray(0).itemArray(25).itemIdentifier = "collectresourcestogether";
CPAPI.orgArray(0).itemArray(25).itemParent = "yourfirstcontentpackage";
CPAPI.orgArray(0).itemArray(25).itemHyper = "content/topic5/subtopic3a.html";
CPAPI.orgArray(0).itemArray(25).keyWords = "This tutorial page describes the process of collecting content.";
CPAPI.orgArray(0).itemArray(25).comments = "collecting content resources,";

CPAPI.orgArray(0).itemArray(26).itemTitle = "Open RELOAD and Set Up Workspace";
CPAPI.orgArray(0).itemArray(26).itemIdentifier = "openreladandsetupworkspace";
CPAPI.orgArray(0).itemArray(26).itemParent = "yourfirstcontentpackage";
CPAPI.orgArray(0).itemArray(26).itemHyper = "content/topic5/subtopic3b.html";
CPAPI.orgArray(0).itemArray(26).keyWords = "new,workspace";
CPAPI.orgArray(0).itemArray(26).comments = "This tutorial page explains how to prepare to make a content package.";

CPAPI.orgArray(0).itemArray(27).itemTitle = "Add Reference to Metadata";
CPAPI.orgArray(0).itemArray(27).itemIdentifier = "addreferencetometadata";
CPAPI.orgArray(0).itemArray(27).itemParent = "yourfirstcontentpackage";
CPAPI.orgArray(0).itemArray(27).itemHyper = "content/topic5/subtopic3c.html";
CPAPI.orgArray(0).itemArray(27).keyWords = "metadata,adding metadata";
CPAPI.orgArray(0).itemArray(27).comments = "This tutorial page describes the first steps in adding metadata.";

CPAPI.orgArray(0).itemArray(28).itemTitle = "Add Organizations and Items";
CPAPI.orgArray(0).itemArray(28).itemIdentifier = "addorganizationsanditems";
CPAPI.orgArray(0).itemArray(28).itemParent = "yourfirstcontentpackage";
CPAPI.orgArray(0).itemArray(28).itemHyper = "content/topic5/subtopic3d.html";
CPAPI.orgArray(0).itemArray(28).keyWords = "content,import resources,organizations, organisations,organization,organizations,item, items,manifest,workspace";
CPAPI.orgArray(0).itemArray(28).comments = "This tutorial page describes how to add content to a Content Package.";

CPAPI.orgArray(0).itemArray(29).itemTitle = "View Content Package";
CPAPI.orgArray(0).itemArray(29).itemIdentifier = "viewcontentpackage";
CPAPI.orgArray(0).itemArray(29).itemParent = "yourfirstcontentpackage";
CPAPI.orgArray(0).itemArray(29).itemHyper = "content/topic5/subtopic3e.html";
CPAPI.orgArray(0).itemArray(29).keyWords = "preview,viewing content packages";
CPAPI.orgArray(0).itemArray(29).comments = "This tutorial page describes how to view Content Packages in a browser.";

CPAPI.orgArray(0).itemArray(30).itemTitle = "Tidy Content Package";
CPAPI.orgArray(0).itemArray(30).itemIdentifier = "tidycontentpackage";
CPAPI.orgArray(0).itemArray(30).itemParent = "yourfirstcontentpackage";
CPAPI.orgArray(0).itemArray(30).itemHyper = "content/topic5/subtopic3f.html";
CPAPI.orgArray(0).itemArray(30).keyWords = "altering,changing";
CPAPI.orgArray(0).itemArray(30).comments = "This tutorial page describes how to amend, change and reorganise Content Packages.";

CPAPI.orgArray(0).itemArray(31).itemTitle = "Add Metadata";
CPAPI.orgArray(0).itemArray(31).itemIdentifier = "addmetadata";
CPAPI.orgArray(0).itemArray(31).itemParent = "yourfirstcontentpackage";
CPAPI.orgArray(0).itemArray(31).itemHyper = "content/topic5/subtopic3g.html";
CPAPI.orgArray(0).itemArray(31).keyWords = "metadata,lom,common,framework,ukcmf,fields,core";
CPAPI.orgArray(0).itemArray(31).comments = "This tutorial page describes how to add metadata.";

CPAPI.orgArray(0).itemArray(32).itemTitle = "Save Content Package";
CPAPI.orgArray(0).itemArray(32).itemIdentifier = "savecontentpackage";
CPAPI.orgArray(0).itemArray(32).itemParent = "yourfirstcontentpackage";
CPAPI.orgArray(0).itemArray(32).itemHyper = "content/topic5/subtopic3h.html";
CPAPI.orgArray(0).itemArray(32).keyWords = "Save Content Preview Package";
CPAPI.orgArray(0).itemArray(32).comments = "This tutorial page describes how to produce a content package in zip format.";

CPAPI.orgArray(0).itemArray(33).itemTitle = "Metadata";
CPAPI.orgArray(0).itemArray(33).itemIdentifier = "metadata";
CPAPI.orgArray(0).itemArray(33).itemParent = "tutorial";
CPAPI.orgArray(0).itemArray(33).itemHyper = "content/topic5/subtopic4.html";
CPAPI.orgArray(0).itemArray(33).keyWords = "metadata,lom,common,framework,ukcmf,fields,core";
CPAPI.orgArray(0).itemArray(33).comments = "This tutorial page describes how to create a standalone metadata file.";

CPAPI.orgArray(0).itemArray(34).itemTitle = "SCORM Elements";
CPAPI.orgArray(0).itemArray(34).itemIdentifier = "scormelements";
CPAPI.orgArray(0).itemArray(34).itemParent = "tutorial";
CPAPI.orgArray(0).itemArray(34).itemHyper = "content/topic5/subtopic5.html";
CPAPI.orgArray(0).itemArray(34).keyWords = "scorm,location,adl,maxtimeallowed,datafromlms,timelimitaction,prerequisites,masteryscore,mastery,time,data";
CPAPI.orgArray(0).itemArray(34).comments = "This tutorial page describes the additional SCORM elements.";

CPAPI.orgArray(0).itemArray(35).itemTitle = "References and Dependencies";
CPAPI.orgArray(0).itemArray(35).itemIdentifier = "referencesanddependencies";
CPAPI.orgArray(0).itemArray(35).itemParent = "tutorial";
CPAPI.orgArray(0).itemArray(35).itemHyper = "content/topic5/subtopic6.html";
CPAPI.orgArray(0).itemArray(35).keyWords = "tructure,dependency,reference,find";
CPAPI.orgArray(0).itemArray(35).comments = "This tutorial page how to add references and dependencies.";

CPAPI.orgArray(0).itemArray(36).itemTitle = "Manifests and Sub-manifests";
CPAPI.orgArray(0).itemArray(36).itemIdentifier = "manifestsandsubmanifests";
CPAPI.orgArray(0).itemArray(36).itemParent = "tutorial";
CPAPI.orgArray(0).itemArray(36).itemHyper = "content/topic5/subtopic7.html";
CPAPI.orgArray(0).itemArray(36).keyWords = "Manifests, Sub Manifest,Sub-Manifest, Aggregation, Aggregate, Disaggregate, Disaggregation";
CPAPI.orgArray(0).itemArray(36).comments = "This tutorial page describes the role of manifests and sub-manifests and explains the process of Aggregation and Disaggregation.";

CPAPI.orgArray(0).itemArray(37).itemTitle = "Menus and Toolbars";
CPAPI.orgArray(0).itemArray(37).itemIdentifier = "menusandtoolbars";
CPAPI.orgArray(0).itemArray(37).itemParent = "menu";
CPAPI.orgArray(0).itemArray(37).itemHyper = "";
CPAPI.orgArray(0).itemArray(37).keyWords = "";
CPAPI.orgArray(0).itemArray(37).comments = "";

CPAPI.orgArray(0).itemArray(38).itemTitle = "RELOAD Tool";
CPAPI.orgArray(0).itemArray(38).itemIdentifier = "reloadtool";
CPAPI.orgArray(0).itemArray(38).itemParent = "menusandtoolbars";
CPAPI.orgArray(0).itemArray(38).itemHyper = "content/topic6/subtopic1.html";
CPAPI.orgArray(0).itemArray(38).keyWords = "what, workspace";
CPAPI.orgArray(0).itemArray(38).comments = "This page describes the RELOAD workspace.";


CPAPI.orgArray(0).itemArray(39).itemTitle = "Menus";
CPAPI.orgArray(0).itemArray(39).itemIdentifier = "menus";
CPAPI.orgArray(0).itemArray(39).itemParent = "menusandtoolbars";
CPAPI.orgArray(0).itemArray(39).itemHyper = "content/topic6/subtopic2.html";
CPAPI.orgArray(0).itemArray(39).keyWords = "menu,menus";
CPAPI.orgArray(0).itemArray(39).comments = "This page introduces the menu section.";

CPAPI.orgArray(0).itemArray(40).itemTitle = "File Menu";
CPAPI.orgArray(0).itemArray(40).itemIdentifier = "filemenu";
CPAPI.orgArray(0).itemArray(40).itemParent = "menus";
CPAPI.orgArray(0).itemArray(40).itemHyper = "content/topic6/subtopic2a.html";
CPAPI.orgArray(0).itemArray(40).keyWords = "file,new,open,import,save,zip,exit,resources";
CPAPI.orgArray(0).itemArray(40).comments = "This page describes the features of the file menu.";

CPAPI.orgArray(0).itemArray(41).itemTitle = "Edit Menu";
CPAPI.orgArray(0).itemArray(41).itemIdentifier = "editmenu";
CPAPI.orgArray(0).itemArray(41).itemParent = "menus";
CPAPI.orgArray(0).itemArray(41).itemHyper = "content/topic6/subtopic2b.html";
CPAPI.orgArray(0).itemArray(41).keyWords = "edit,undo,redo,cut,copy,paste,delete,move up,move dn";
CPAPI.orgArray(0).itemArray(41).comments = "This page describes the features of the edit menu.";

CPAPI.orgArray(0).itemArray(42).itemTitle = "Tools Menu";
CPAPI.orgArray(0).itemArray(42).itemIdentifier = "toolsmenu";
CPAPI.orgArray(0).itemArray(42).itemParent = "menus";
CPAPI.orgArray(0).itemArray(42).itemHyper = "content/topic6/subtopic2c.html";
CPAPI.orgArray(0).itemArray(42).keyWords = "options";
CPAPI.orgArray(0).itemArray(42).comments = "This page describes the features of the options menu.";

CPAPI.orgArray(0).itemArray(43).itemTitle = "View Menu";
CPAPI.orgArray(0).itemArray(43).itemIdentifier = "viewmenu";
CPAPI.orgArray(0).itemArray(43).itemParent = "menus";
CPAPI.orgArray(0).itemArray(43).itemHyper = "content/topic6/subtopic2d.html";
CPAPI.orgArray(0).itemArray(43).keyWords = "preview,look and feel,status";
CPAPI.orgArray(0).itemArray(43).comments = "This page describes the features of the view menu.";

CPAPI.orgArray(0).itemArray(44).itemTitle = "Window Menu";
CPAPI.orgArray(0).itemArray(44).itemIdentifier = "windowmenu";
CPAPI.orgArray(0).itemArray(44).itemParent = "menus";
CPAPI.orgArray(0).itemArray(44).itemHyper = "content/topic6/subtopic2e.html";
CPAPI.orgArray(0).itemArray(44).keyWords = "multiple packages,cascade,tile";
CPAPI.orgArray(0).itemArray(44).comments = "This page describes the features of the window menu.";

CPAPI.orgArray(0).itemArray(45).itemTitle = "Help Menu";
CPAPI.orgArray(0).itemArray(45).itemIdentifier = "helpmenu";
CPAPI.orgArray(0).itemArray(45).itemParent = "menus";
CPAPI.orgArray(0).itemArray(45).itemHyper = "content/topic6/subtopic2f.html";
CPAPI.orgArray(0).itemArray(45).keyWords = "help";
CPAPI.orgArray(0).itemArray(45).comments = "This page describes the features of the help menu.";

CPAPI.orgArray(0).itemArray(46).itemTitle = "Toolbar";
CPAPI.orgArray(0).itemArray(46).itemIdentifier = "toolbar";
CPAPI.orgArray(0).itemArray(46).itemParent = "menusandtoolbars";
CPAPI.orgArray(0).itemArray(46).itemHyper = "content/topic6/subtopic3.html";
CPAPI.orgArray(0).itemArray(46).keyWords = "toolbars";
CPAPI.orgArray(0).itemArray(46).comments = "This page describes the makeup of the toolbars.";

CPAPI.orgArray(0).itemArray(47).itemTitle = "Customising RELOAD";
CPAPI.orgArray(0).itemArray(47).itemIdentifier = "customisingreload";
CPAPI.orgArray(0).itemArray(47).itemParent = "menusandtoolbars";
CPAPI.orgArray(0).itemArray(47).itemHyper = "content/topic6/subtopic4.html";
CPAPI.orgArray(0).itemArray(47).keyWords = "customising,application profiles,vocabulary,metadata,vdex";
CPAPI.orgArray(0).itemArray(47).comments = "This page describes how you may customise RELOAD to use specifc Application Profiles.";

CPAPI.orgArray(0).itemArray(48).itemTitle = "Internationalisation";
CPAPI.orgArray(0).itemArray(48).itemIdentifier = "Internationalisation";
CPAPI.orgArray(0).itemArray(48).itemParent = "menusandtoolbars";
CPAPI.orgArray(0).itemArray(48).itemHyper = "content/topic6/subtopic5.html";
CPAPI.orgArray(0).itemArray(48).keyWords = "internationalization, internationalisation";
CPAPI.orgArray(0).itemArray(48).comments = "This page describes how you can internationalize your version of Reload.";



