/*
 * Decompiled with CFR 0.152.
 */
package com.mja.math3D;

import com.mja.math3D.R3;

public class LinearTransformation {
    private double[][] M = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    private R3 T = new R3(0.0, 0.0, 0.0);

    public static LinearTransformation Scale(double d) {
        LinearTransformation linearTransformation = new LinearTransformation();
        int n = 0;
        while (n < 3) {
            double[] dArray = linearTransformation.M[n];
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
        return linearTransformation;
    }

    public static LinearTransformation Rotation(int n, double d) {
        LinearTransformation linearTransformation = new LinearTransformation();
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        if (n == 0) {
            linearTransformation.M[1][1] = d2;
            linearTransformation.M[1][2] = -d3;
            linearTransformation.M[2][1] = d3;
            linearTransformation.M[2][2] = d2;
        } else if (n == 1) {
            linearTransformation.M[2][2] = d2;
            linearTransformation.M[2][0] = -d3;
            linearTransformation.M[0][2] = d3;
            linearTransformation.M[0][0] = d2;
        } else if (n == 2) {
            linearTransformation.M[0][0] = d2;
            linearTransformation.M[0][1] = -d3;
            linearTransformation.M[1][0] = d3;
            linearTransformation.M[1][1] = d2;
        }
        return linearTransformation;
    }

    public static LinearTransformation Transposed(LinearTransformation linearTransformation) {
        LinearTransformation linearTransformation2 = new LinearTransformation();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                linearTransformation2.M[i][j] = linearTransformation.M[j][i];
            }
        }
        return linearTransformation2;
    }

    public static LinearTransformation Rotation(R3 r3) {
        LinearTransformation linearTransformation = LinearTransformation.Rotation(0, r3.x);
        LinearTransformation linearTransformation2 = LinearTransformation.Rotation(1, r3.y);
        LinearTransformation linearTransformation3 = LinearTransformation.Rotation(2, r3.z);
        return LinearTransformation.Multiply(linearTransformation3, LinearTransformation.Multiply(linearTransformation2, linearTransformation));
    }

    public static LinearTransformation EulerRotation(R3 r3) {
        LinearTransformation linearTransformation = LinearTransformation.Rotation(2, r3.z);
        LinearTransformation linearTransformation2 = LinearTransformation.Rotation(0, r3.y);
        LinearTransformation linearTransformation3 = LinearTransformation.Rotation(2, r3.x);
        return LinearTransformation.Multiply(linearTransformation3, LinearTransformation.Multiply(linearTransformation2, linearTransformation));
    }

    public static LinearTransformation Rotation(LinearTransformation linearTransformation, R3 r3) {
        return LinearTransformation.Multiply(linearTransformation, LinearTransformation.Rotation(r3));
    }

    public static LinearTransformation RigidMotion(boolean bl, R3 r3, R3 r32) {
        LinearTransformation linearTransformation = LinearTransformation.Rotation(r3);
        if (bl) {
            linearTransformation = LinearTransformation.EulerRotation(r3);
        }
        linearTransformation.T = r32;
        return linearTransformation;
    }

    public void Apply(R3 r3) {
        double d = r3.x;
        double d2 = r3.y;
        double d3 = r3.z;
        r3.x = this.T.x + this.M[0][0] * d + this.M[0][1] * d2 + this.M[0][2] * d3;
        r3.y = this.T.y + this.M[1][0] * d + this.M[1][1] * d2 + this.M[1][2] * d3;
        r3.z = this.T.z + this.M[2][0] * d + this.M[2][1] * d2 + this.M[2][2] * d3;
    }

    public static LinearTransformation Multiply(LinearTransformation linearTransformation, LinearTransformation linearTransformation2) {
        LinearTransformation linearTransformation3 = new LinearTransformation();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                linearTransformation3.M[i][j] = 0.0;
                for (int k = 0; k < 3; ++k) {
                    double[] dArray = linearTransformation3.M[i];
                    int n = j;
                    dArray[n] = dArray[n] + linearTransformation.M[i][k] * linearTransformation2.M[k][j];
                }
            }
        }
        return linearTransformation3;
    }

    public static double[][] Multiply(double[][] dArray, double[][] dArray2) {
        int n = dArray2.length;
        int n2 = dArray[0].length;
        double[][] dArray3 = new double[n][n2];
        int n3 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = 0.0;
                for (int k = 0; k < n3; ++k) {
                    d += dArray[k][i] * dArray2[j][k];
                }
                dArray3[j][i] = d;
            }
        }
        return dArray3;
    }

    public static double[][] Minor(int n, int n2, double[][] dArray) {
        double[][] dArray2 = new double[dArray.length - 1][dArray.length - 1];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2.length; ++j) {
                if (i < n) {
                    if (j < n2) {
                        dArray2[i][j] = dArray[i][j];
                        continue;
                    }
                    dArray2[i][j] = dArray[i][j + 1];
                    continue;
                }
                dArray2[i][j] = j < n2 ? dArray[i + 1][j] : dArray[i + 1][j + 1];
            }
        }
        return dArray2;
    }

    public static double Determinant(double[][] dArray) {
        if (dArray.length > 1) {
            double d = 0.0;
            double d2 = 1.0;
            for (int i = 0; i < dArray.length; ++i) {
                d += d2 * dArray[0][i] * LinearTransformation.Determinant(LinearTransformation.Minor(0, i, dArray));
                d2 = -d2;
            }
            return d;
        }
        return dArray[0][0];
    }

    public static double[][] inverse(double[][] dArray) throws Exception {
        double[][] dArray2 = new double[dArray.length][dArray.length];
        double d = LinearTransformation.Determinant(dArray);
        if (d == 0.0) {
            throw new Exception("Matrix not invertible");
        }
        double d2 = 1.0 / d;
        if (dArray.length > 1) {
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = d2;
                for (int j = 0; j < dArray.length; ++j) {
                    dArray2[j][i] = d3 * LinearTransformation.Determinant(LinearTransformation.Minor(i, j, dArray));
                    d3 = -d3;
                }
                d2 = -d2;
            }
        } else {
            dArray2[0][0] = d2;
        }
        return dArray2;
    }

    public static R3 apply(R3[] r3Array, R3 r3) {
        return new R3(r3Array[0].x * r3.x + r3Array[1].x * r3.y + r3Array[2].x * r3.z, r3Array[0].y * r3.x + r3Array[1].y * r3.y + r3Array[2].y * r3.z, r3Array[0].z * r3.x + r3Array[1].z * r3.y + r3Array[2].z * r3.z);
    }
}

